// siehe: http://people.csail.mit.edu/rivest/lcs35-puzzle-description.txt

import java.math.BigInteger;

public class TimeLockAufgabe {

    // Die folgenden drei Werte braucht man zur Erzeugen des Raetsels
    private BigInteger p;
    private BigInteger q;
    public  BigInteger t;
    
    // Die folgenden Werte werden im Konstruktor aus den vorhergehenden drei berechnet    
    public  BigInteger n;
    private BigInteger pMinusOne;
    private BigInteger qMinusOne;
    private BigInteger phi;
    
    private BigInteger w; // der Schluessel als Zahl
    private String wHex;  // der Schluessel als Hexadezimalstring
    
    private String klartext;    //der Klartexte als Text
    private String klartextHex; //der Klarext als Hexadezimalstring
    public  String geheimtextHex;       //der mit dem Schluessel verschluesselte Klartext als Hexadezimalstring
    

    public TimeLockAufgabe ()  {
            this (
                "Hallo",
                new BigInteger("5"),
                new BigInteger("807793566946316088741610050849573099185363389551639556884765763"),
                new BigInteger("79685186856218")
            );

    }
    /**
     * Konstruktor fuer die Raetselaufgabe.
     * Alle noetigen Informationen werden aus den Eingabewerten berechnet und in Attributen gespeichert.
     * 
     * @param klartext Der zu verschluesselnde Text.
     * @param p Eine hohe Primzahl mit ein paar hundert Stellen.
     * @param q Eine hohe Primzahl mit ein paar hundert Stellen.
     * @param t Eine Zahl, die quasi den Schwierigkeitsgrad der Verschluesselung angibt.
     * 
     */
    public TimeLockAufgabe (String klartext, BigInteger p, BigInteger q, BigInteger t)  {
        this.klartext = klartext;
        this.p = p;
        this.q = q;
        this.t = t;
        
        n = p.multiply(q);
        pMinusOne = p.subtract(BigInteger.ONE);
        qMinusOne = q.subtract(BigInteger.ONE);
        phi = pMinusOne.multiply(qMinusOne);    

        // Berechnung der Loesung
        BigInteger u = new BigInteger("2").modPow(t,phi);
        w = new BigInteger("2").modPow(u,n);
        
        klartextHex = Hilfsmethoden.verschluesseln(klartext, new BigInteger("0"));
        wHex = Hilfsmethoden.bigIntegerToHex(w);
        geheimtextHex = Hilfsmethoden.verschluesseln(klartext, w);         

        
    }

    /**
     * Gibt die wichtigen Daten zum Time-Lock-Puzzle aus, einschliesslich einer probeweisen Ver- und Entschluesselung
     */
    public void datenAusgeben()  {
        // Ausgeben der Daten
        System.out.println("p:   "+p);
        System.out.println("q:   "+q);
        System.out.println("t:   "+t);
        System.out.println("n:   "+n);
        System.out.println("phi: "+phi);
        System.out.println("w:   "+w);

        System.out.println();
        
        schoenDarstellen(klartext, klartextHex, wHex, geheimtextHex);

        System.out.println();
        System.out.println("Loesung (Test): "+Hilfsmethoden.entschluesseln(geheimtextHex, Hilfsmethoden.bigIntegerToHex(w)));              
        System.out.println();

    }
    
    /**
     * Erzeugt einen String, der nur aus einer Anzahl von Leerzeichen besteht
     */
    private String leerstring(int anzahlLeerzeichen) {
        String s = "";
        for (int i=0;i<anzahlLeerzeichen;i++) {
            s = " "+s;
        }
        return s;
    }
    
    /** 
     * Fuegt bei einem gegebenen String Leerzeichen nach jedem Zeichen ein.
     * @param s der urspruengliche String
     * @return das gesperrt formatierte Aequivalent dazu 
     */
    private String gesperrt(String s) {
        String ergebnis = "";
        for (int i=0; i<s.length(); i++) {
            ergebnis = ergebnis + s.charAt(i)+" ";
        }
        return ergebnis;
    }
    
    /** 
     * Gibt die Eingabewerte in formatierter Form auf die Konsole aus.
     * Dabei erscheinen alle Strings rechtsbuendig, damit man XOR besser vergleichen kann.
     * 
     * @param klartext  der unverschluesselte Klartext
     * @param klartext Hex der unverschluesselte Klartext, hexadezimal kodiert
     * @param wHex der Schluessel, hexadezimal kodiert
     * @param geheimtext das Ergebnis der XOR-Operation auf Schluessel und Klartext
     */
    private void schoenDarstellen(String klartext, String klartextHex, String wHex, String geheimtext) {
        
        int unterschied = klartextHex.length()-wHex.length();
        String abstand1 = "";
        String abstand2 = "";
        if (unterschied<0) {
            abstand1 = leerstring(-unterschied);
        } else {
            abstand2 = leerstring(unterschied);
        }        

        System.out.println("Klartext:       "+abstand1+gesperrt(klartext));
        System.out.println("Klartext (hex): "+abstand1+klartextHex+" (Laenge: "+klartextHex.length()+")");
        System.out.println("w (hex):        "+abstand2+wHex+" (Laenge: "+wHex.length()+")");
        System.out.println("Geheimtext:     "+geheimtext);
    }

    
    


}
